% Keithley KPCI-3108
% Ananlog post trigger with delay
% This example gathers data on Ch0,1,2
fprintf('Connect the Analog Trigger line to (Ch0) Pin 33 of STP-36'); 

% 1. create device object
    ai = analoginput('keithley',0); 
% 2. Add channels
    ch = addchannel(ai,0:2);
    set(ch,'InputRange',[-5 5])
% 3. Configure property values 
    sfreq = 4000;
    nPoints = 550;      %total data points
    set(ai,'SampleRate',sfreq)
    set(ai,'SamplesPerTrigger',nPoints) 

%4. Configure for Analog Trigger
    %The channel skew is automatically calculated 
    %as [(sampling rate)(number of channels)] ^ -1.
    set(ai,'ChannelSkewMode','Equisample')
    set(ai,'TriggerChannel',ch(1))
    set(ai,'TriggerType','Software')    %Analog trigger
    set(ai,'TriggerCondition','Rising') 
    set(ai,'TriggerConditionValue',1)   %threshold V
    set(ai,'TriggerDelayUnits','Seconds')
    set(ai,'TriggerDelay',0.0002)        %post-trigger delay in secs
    set(ai,'Timeout',10)                 %set the timeout in secs
%5. Get data   
    start(ai)
    [data,time] = getdata(ai);
    while strcmp(ai.Running,'On')
    end

%6. Plot Data
    figure(1)
    plot(time(1:50),data(1:50,:) ),ylabel('Input Voltage(V)'),xlabel('Relative Time(sec)')
    title('KPCI-3108: Analog Trigger on CH 0') 
    legend('Ch0','Ch1','Ch2')
    
    figure(2)
    plot(data(1:100,:)),legend('Ch0','Ch1','Ch2')
    ylabel('Input Voltage (V)'), xlabel('samples')
    title('KPCI-3108: Analog Trigger on CH 0') 
    fprintf('Note: This example demonstrates the post trigger with delay');
%7. clear the memory
    delete(ai)  
    clear ai    
    clear all